/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class C2S_PlaySoundFromAnimationEventPacket
extends AbstractNetworkPacket<C2S_PlaySoundFromAnimationEventPacket> {
    private final ResourceLocation soundId;
    private final float volume;
    private final float pitch;

    public C2S_PlaySoundFromAnimationEventPacket() {
        this(null, 0.0f, 0.0f);
    }

    public C2S_PlaySoundFromAnimationEventPacket(ResourceLocation soundId, float volume, float pitch) {
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.soundId);
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
    }

    @Override
    public C2S_PlaySoundFromAnimationEventPacket decode(PacketBuffer buffer) {
        ResourceLocation soundId = buffer.func_192575_l();
        float volume = buffer.readFloat();
        float pitch = buffer.readFloat();
        return new C2S_PlaySoundFromAnimationEventPacket(soundId, volume, pitch);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity serverPlayer = context.getSender();
        IForgeRegistry soundRegistry = ForgeRegistries.SOUND_EVENTS;
        if (!soundRegistry.containsKey(this.soundId)) {
            return;
        }
        SoundEvent event = (SoundEvent)soundRegistry.getValue(this.soundId);
        serverPlayer.field_70170_p.func_184148_a((PlayerEntity)serverPlayer, serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_(), serverPlayer.func_226281_cx_(), event, SoundCategory.PLAYERS, this.volume, this.pitch);
    }
}

